# ZNZ dynpricing - Chrome Extension

Chrome extension pro rychlý přístup k debug panelu dynpricing přímo z e-commerce stránek.

## 🚀 Funkce

- **Automatická detekce produktů** - Rozpozná `page_data` na stránkách e-shopů
- **Rychlý přístup k debug** - Jeden klik pro otevření debug panelu s produktem
- **Podpora více domén** - Automatické mapování domény na strategy_id
- **Přesouvatelný widget** - Widget můžete přetáhnout kamkoliv na stránce
- **SPA podpora** - Funguje i na single-page aplikacích

## 📦 Instalace

### Metoda 1: Načtení rozbalené složky (Developer Mode)

1. Otevřete Chrome a přejděte na `chrome://extensions/`
2. Zapněte **Developer mode** (přepínač vpravo nahoře)
3. Klikněte na **Load unpacked**
4. Vyberte složku `chrome` z tohoto projektu
5. Extension se nainstaluje a bude aktivní

### Metoda 2: Zabalení jako .crx (pro distribuci)

1. Na stránce `chrome://extensions/` klikněte **Pack extension**
2. Vyberte složku `chrome`
3. Vytvořený `.crx` soubor můžete distribuovat

## 🔧 Použití

1. Navštivte jakoukoliv podporovanou e-commerce stránku (např. casadelprofumo.it)
2. Pokud stránka obsahuje produkt s `page_data`, zobrazí se widget vpravo dole
3. Widget zobrazuje:
   - Doménu a Strategy ID
   - Seznam produktů na stránce
   - Pro každý produkt tlačítko **Debug**
4. Kliknutím na **Debug** se otevře admin panel s pre-vyplněnými parametry

## 🌐 Podporované domény

Extension automaticky mapuje domény na strategy_id:

| Doména | Strategy ID |
|--------|-------------|
| casadelprofumo.it | 19 |
| parfum-zentrum.de | 1 |
| parfuemerie.de | 2 |
| beautywelt.de | 3 |
| flaconi.de | 4 |
| notino.cz | 5 |
| notino.de | 6 |
| notino.it | 7 |
| douglas.de | 8 |
| douglas.cz | 9 |
| douglas.it | 10 |
| parfumdreams.de | 11 |
| parfumdreams.it | 12 |
| easycosmeticos.com | 13 |

Pro ostatní domény se použije výchozí strategy_id 19.

## ⚙️ Konfigurace

Chcete-li přidat nové domény nebo změnit mapování, upravte soubor `content.js`:

```javascript
const DOMAIN_STRATEGY_MAP = {
    'novy-eshop.cz': 20,
    // ... další domény
};
```

## 🔍 Detekovaná data

Extension hledá na stránce:

1. Script tag obsahující `page_data = {...}`
2. Globální proměnnou `window.page_data`

Z těchto dat extrahuje:
- `idProduct` / `id` / `productId`
- `EAN`
- `code` / `productCode`
- `name`
- `price` / `priceWithVat`
- `producer` / `brand`

## 🐛 Ladění

Otevřete DevTools (F12) a v konzoli hledejte zprávy s prefixem `[ZNZ dynpricing]`:

```
[ZNZ dynpricing] Found 1 product(s) on casadelprofumo.it
[ZNZ dynpricing] Widget created with 1 product(s)
```

## 📁 Struktura souborů

```
chrome/
├── manifest.json    # Manifest extension
├── content.js       # Hlavní skript
├── styles.css       # Styly widgetu
├── README.md        # Tento soubor
└── icons/           # Ikony extension
    ├── icon16.png
    ├── icon48.png
    └── icon128.png
```

## 🔒 Oprávnění

Extension vyžaduje:
- `activeTab` - přístup k aktuální záložce
- `scripting` - vkládání skriptů
- Host permissions - přístup k e-commerce doménám

## 📝 Changelog

### v1.0.0
- Počáteční verze
- Detekce page_data
- Widget s debug odkazy
- Podpora více domén
