<?php
/**
 * Generate PNG icons for Chrome Extension
 * Run: php generate_icons.php
 */

function createIcon($size, $filename) {
    // Create image
    $image = imagecreatetruecolor($size, $size);
    
    // Enable alpha blending
    imagealphablending($image, true);
    imagesavealpha($image, true);
    
    // Colors
    $gold = imagecolorallocate($image, 216, 164, 25);      // #d8a419
    $lightGold = imagecolorallocate($image, 240, 192, 64); // #f0c040
    $white = imagecolorallocate($image, 255, 255, 255);
    $darkBlue = imagecolorallocate($image, 26, 26, 46);   // #1a1a2e
    
    // Fill background with gradient effect (simple approximation)
    for ($y = 0; $y < $size; $y++) {
        for ($x = 0; $x < $size; $x++) {
            $ratio = ($x + $y) / ($size * 2);
            $r = (int)(216 + (240 - 216) * $ratio);
            $g = (int)(164 + (192 - 164) * $ratio);
            $b = (int)(25 + (64 - 25) * $ratio);
            $color = imagecolorallocate($image, $r, $g, $b);
            imagesetpixel($image, $x, $y, $color);
        }
    }
    
    // Draw rounded corners (make corners transparent)
    $transparent = imagecolorallocatealpha($image, 0, 0, 0, 127);
    $radius = (int)($size * 0.15);
    
    // Top-left corner
    imagefilledarc($image, $radius, $radius, $radius * 2, $radius * 2, 180, 270, $transparent, IMG_ARC_PIE);
    // Top-right corner  
    imagefilledarc($image, $size - $radius - 1, $radius, $radius * 2, $radius * 2, 270, 360, $transparent, IMG_ARC_PIE);
    // Bottom-left corner
    imagefilledarc($image, $radius, $size - $radius - 1, $radius * 2, $radius * 2, 90, 180, $transparent, IMG_ARC_PIE);
    // Bottom-right corner
    imagefilledarc($image, $size - $radius - 1, $size - $radius - 1, $radius * 2, $radius * 2, 0, 90, $transparent, IMG_ARC_PIE);
    
    // Draw "E" letter
    $fontSize = $size * 0.5;
    $font = 5; // Built-in font (largest)
    
    // For larger icons, use imagestring multiple times to create bold effect
    if ($size >= 48) {
        $letter = 'E';
        $fontWidth = imagefontwidth($font);
        $fontHeight = imagefontheight($font);
        $x = ($size - $fontWidth) / 2;
        $y = ($size - $fontHeight) / 2;
        
        // Draw multiple times for "bold" effect
        for ($i = -1; $i <= 1; $i++) {
            for ($j = -1; $j <= 1; $j++) {
                imagestring($image, $font, $x + $i, $y + $j, $letter, $white);
            }
        }
    } else {
        $letter = 'E';
        $fontWidth = imagefontwidth($font);
        $fontHeight = imagefontheight($font);
        $x = ($size - $fontWidth) / 2;
        $y = ($size - $fontHeight) / 2;
        imagestring($image, $font, $x, $y, $letter, $white);
    }
    
    // For 128px icon, add badge
    if ($size === 128) {
        $badgeSize = 36;
        $badgeX = $size - $badgeSize - 8;
        $badgeY = $size - $badgeSize - 8;
        
        // Badge circle
        imagefilledellipse($image, $badgeX + $badgeSize/2, $badgeY + $badgeSize/2, $badgeSize, $badgeSize, $darkBlue);
        
        // Badge text "LP"
        $lpX = $badgeX + 8;
        $lpY = $badgeY + 13;
        imagestring($image, 3, $lpX, $lpY, 'LP', $gold);
    }
    
    // Save PNG
    imagepng($image, $filename);
    imagedestroy($image);
    
    echo "Created: $filename ({$size}x{$size})\n";
}

// Create icons
createIcon(16, __DIR__ . '/icon16.png');
createIcon(48, __DIR__ . '/icon48.png');
createIcon(128, __DIR__ . '/icon128.png');

echo "\nAll icons created successfully!\n";
echo "You can now load the extension in Chrome.\n";
